%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for 
%   educational purposes associated with the book
%
%
%

% Parallel-plate capacitor with N dielectric layers.
% This program calculates breakdown voltage in parallel plate capacitor
% with arbitrary number of dielectric layers parallel to the capacitor
% plates

clear all;
close all;
EPS0 = 8.8542*10^(-12); 

% Number of dielectric layers
N = input('Enter the number of layers parallel to the plates of capacitor: ');

% Dielectric permittivity constant and dielectric strength for each 
% dielectric layer
for i = 1:N
    EPSR(i) = input(['Enter dielectric rel. permittivity in ',int2str(i),'. layer: ']);
    Ecr(i) = input(['Enter dielectric strength (in MV/m) for ',int2str(i),'. layer: ']);
    Ecr(i) = Ecr(i)*10^6;
    d(i) = input(['Enter the width (in mm) for ',int2str(i),'. layer: ']);
    d(i) = d(i)/1000;
end;

% Maximum of electric flux density vector in each layer - before breakdown
D = EPS0.*EPSR.*Ecr;

% In which layer will happen breakdown
[Dmin,index] = min(D);
fprintf(['Breakdown will happen in ',int2str(index),'. dielectric layer for D = ']);
fprintf('%f uC/m^2.\n',Dmin*10^6);

% Electric field intesity vector in each dielectric
E = Ecr(index)*EPSR(index)./EPSR;  
% Breakdown voltage
Vcr = dot(E,d);
fprintf('Breakdown voltage is: %f V.\n',Vcr)